 
// #4X 2010 World Clock       \/
// Knowledge of the ancients ( )
//______________________o0o___(_)___o0o_____
//___Xard777_____________________2010_

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red

#import "kernel32.dll"
   void GetLocalTime(int& a0[]);
   void GetSystemTime(int& a0[]);
   int GetTimeZoneInformation(int& a0[]);
   bool SystemTimeToTzSpecificLocalTime(int& a0[], int& a1[], int& a2[]);
#import

extern string _INFO_Set_your_computer_clock = "Accuracy depends on YOUR CPU CLOCK!!";
extern string _INFO_Verify_times_with_URL = "http://www.worldtimezone.net/index24.php";
extern string _INFO_Re_labelCorner = "0=Top-left, 1=TR, 2=BL, 3=BR";
extern int labelCorner = 1;
extern int topOffsetPixels = 3;
extern int WhatWindow = 1;
extern color labelColor = DimGray;//C'160,0,0';
extern color clockColor = DimGray;//C'160,0,0';
extern color labelMktOpenColor = Silver;//C'0,160,0';
extern color clockMktOpenColor = Silver;//C'0,160,0';
extern bool Highlight_Market_Open = TRUE;
extern bool Display_Times_With_AMPM = FALSE;
extern bool Broker_MMSS_Is_Gold_Standard = TRUE;
extern bool Display_Time_With_Seconds = FALSE;
extern string _INFO_Re_Bar_With_Seconds = "0=No; 1=Yes; 2=Auto";
extern int Display_Bar_With_Seconds = 1;
extern bool Suppress_Bar_HH_Below_H1 = TRUE;
extern bool ShowAuckland = FALSE;
extern bool ShowSydney = TRUE;
extern bool ShowTokyo = TRUE;
extern bool ShowMoscow = TRUE;
extern bool ShowBerlin = TRUE;
extern bool ShowLondon = TRUE;
extern bool ShowNewYork = TRUE;
extern bool ShowSeattle = false;
extern bool ShowUTC_GMT = false;
extern bool ShowLocal = false;
extern bool Show_DIBS_London = FALSE;
extern int DIBS_LondonOpenHour = 6;
extern int DIBS_LondonCloseHour = 15;
extern bool Weekend_Test_Mode = FALSE;
bool gi_212 = FALSE;
int gia_216[43];
int gia_220[43];
int gia_224[43];
int gia_228[43];
int gia_232[43];
int gia_236[43];
int gia_240[43];
int gia_244[43];
int gia_248[43];
double g_ibuf_252[];
int gi_256 = 8;
int gi_260 = 17;
int gi_264 = 7;
int gi_268 = 16;
int g_datetime_272;

int init() {
   SetIndexStyle(0, DRAW_NONE);
   SetIndexBuffer(0, g_ibuf_252);
   if (gi_212) writeLocalTZInfoToFile("tzdata.csv", 0);
   GetAllTimeZoneInfo(gia_216, gia_220, gia_224, gia_228, gia_232, gia_236, gia_240, gia_244, gia_248);
   int li_0 = topOffsetPixels;
   int li_4 = 90;
   int li_8 = 22;
   if (!Display_Times_With_AMPM && !Display_Time_With_Seconds && Display_Bar_With_Seconds == 0) li_8 = 42;
   else
      if (Display_Times_With_AMPM && !Display_Time_With_Seconds) li_8 = 32;
   if (Display_Times_With_AMPM) li_4 = 102;
   int li_12 = 0;
   if (ShowAuckland) {
      ObjectMakeLabel("auckl", li_4, li_0 + li_12);
      ObjectMakeLabel("auckt", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowSydney) {
      ObjectMakeLabel("sydl", li_4, li_0 + li_12);
      ObjectMakeLabel("sydt", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowTokyo) {
      ObjectMakeLabel("tokl", li_4, li_0 + li_12);
      ObjectMakeLabel("tokt", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowMoscow) {
      ObjectMakeLabel("mosl", li_4, li_0 + li_12);
      ObjectMakeLabel("most", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowBerlin) {
      ObjectMakeLabel("berl", li_4, li_0 + li_12);
      ObjectMakeLabel("bert", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowLondon) {
      ObjectMakeLabel("lonl", li_4, li_0 + li_12);
      ObjectMakeLabel("lont", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowNewYork) {
      ObjectMakeLabel("nyl", li_4, li_0 + li_12);
      ObjectMakeLabel("nyt", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowSeattle) {
      ObjectMakeLabel("seal", li_4, li_0 + li_12);
      ObjectMakeLabel("seat", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowUTC_GMT) {
      ObjectMakeLabel("utcl", li_4, li_0 + li_12);
      ObjectMakeLabel("utct", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (Show_DIBS_London) {
      ObjectMakeLabel("dibsl", li_4, li_0 + li_12);
      ObjectMakeLabel("dibst", li_8, li_0 + li_12);
      li_12 += 15;
   }
   if (ShowLocal) {
      ObjectMakeLabel("locl", li_4, li_0 + li_12);
      ObjectMakeLabel("loct", li_8, li_0 + li_12);
      li_12 += 15;
   }
   return (0);
}

int start() {
   int lia_0[4];
   int lia_4[4];
   int lia_8[4];
   int lia_12[4];
   int lia_16[4];
   int lia_20[4];
   int lia_24[4];
   int lia_28[4];
   int lia_32[4];
   int lia_36[4];
   int li_40;
   int l_datetime_44;
   int li_48;
   int li_52;
   int li_56;
   int li_60;
   int li_64;
   int li_68;
   int li_72;
   int li_76;
   int li_80;
   int li_84;
   string l_text_88;
   string l_text_96;
   string l_text_104;
   string l_text_112;
   string l_text_120;
   string l_text_128;
   string l_text_136;
   string l_text_144;
   string l_text_152;
   string l_text_160;
   string l_text_168;
   int li_176;
   string l_time2str_180;
   if (!IsDllsAllowed()) {
      if (TimeCurrent() - g_datetime_272 >= 7) {
         g_datetime_272 = TimeCurrent();
         Alert(WindowExpertName(), ": ERROR. DLLs are disabled. To enable, select \'Allow DLL Imports\' in the Common Tab of indicator");
      }
   } else {
      if (!Weekend_Test_Mode && TimeCurrent() - g_datetime_272 == 0) return;
      g_datetime_272 = TimeCurrent();
      GetLocalTime(lia_0);
      li_40 = TimeArrayToTime(lia_0);
      l_datetime_44 = TimeCurrent();
      li_48 = 0;
      if (Broker_MMSS_Is_Gold_Standard && !Weekend_Test_Mode) {
         li_48 = 60 * TimeMinute(l_datetime_44) + TimeSeconds(l_datetime_44) - 60 * TimeMinute(li_40) - TimeSeconds(li_40);
         if (li_48 > 1800) li_48 -= 3600;
         else
            if (li_48 < -1800) li_48 += 3600;
      }
      GetSystemTime(lia_4);
      li_52 = TimeArrayToTime(lia_4) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_220, lia_4, lia_8);
      li_56 = TimeArrayToTime(lia_8) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_232, lia_4, lia_20);
      li_60 = TimeArrayToTime(lia_20) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_224, lia_4, lia_12);
      li_64 = TimeArrayToTime(lia_12) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_228, lia_4, lia_16);
      li_68 = TimeArrayToTime(lia_16) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_236, lia_4, lia_24);
      li_72 = TimeArrayToTime(lia_24) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_240, lia_4, lia_28);
      li_76 = TimeArrayToTime(lia_28) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_244, lia_4, lia_32);
      li_80 = TimeArrayToTime(lia_32) + li_48;
      SystemTimeToTzSpecificLocalTime(gia_248, lia_4, lia_36);
      li_84 = TimeArrayToTime(lia_36) + li_48;
      l_text_88 = TimeToString(li_52);
      l_text_96 = TimeToString(li_60);
      l_text_104 = TimeToString(li_40);
      l_text_112 = TimeToString(li_64);
      l_text_120 = TimeToString(li_68);
      l_text_128 = TimeToString(li_72);
      l_text_136 = TimeToString(li_76);
      l_text_144 = TimeToString(li_80);
      l_text_152 = TimeToString(li_84);
      l_text_160 = TimeToString(li_56);
      l_text_168 = TimeToString(TimeCurrent());
      li_176 = 60 * Period() + Time[0] - TimeCurrent();
      if (li_176 >= 0) {
         if (Display_Bar_With_Seconds != 0 && Display_Bar_With_Seconds == 1 || Display_Time_With_Seconds || (Display_Bar_With_Seconds == 2 && li_176 < 120)) l_time2str_180 = TimeToStr(60 * Period() + Time[0] - TimeCurrent(), TIME_MINUTES|TIME_SECONDS);
         else l_time2str_180 = TimeToStr(60 * Period() + Time[0] - TimeCurrent(), TIME_MINUTES);
         if (Suppress_Bar_HH_Below_H1 && Period() <= PERIOD_H1 && StringLen(l_time2str_180) > 6) l_time2str_180 = StringSubstr(l_time2str_180, 3);
      } else {
         if (Display_Bar_With_Seconds == 0) l_time2str_180 = "wait";
         else l_time2str_180 = "wait4bar";
      }
      if (Show_DIBS_London) {
         if (TimeDayOfWeek(li_64) != 0 && TimeDayOfWeek(li_64) != 8 && Highlight_Market_Open && TimeHour(li_64) >= DIBS_LondonOpenHour && TimeHour(li_64) < DIBS_LondonCloseHour) {
            ObjectSetText("dibsl", "* DIBS UK:", 10, "Arial", labelMktOpenColor);
            ObjectSetText("dibst", l_text_112, 10, "Arial", clockMktOpenColor);
         } else {
            ObjectSetText("dibsl", "DIBS UK:", 8, "Arial", labelColor);
            ObjectSetText("dibst", l_text_112, 8, "Arial", clockColor);
         }
      }
      if (ShowLocal) {
         ObjectSetText("locl", "Bangladesh:", 10, "Arial", labelColor);
         ObjectSetText("loct", l_text_104, 10, "Arial", clockColor);
      }
      if (ShowUTC_GMT) {
         ObjectSetText("utcl", "UTC_GMT:", 8, "Arial", labelColor);
         ObjectSetText("utct", l_text_88, 8, "Arial", clockColor);
      }
      if (ShowNewYork) {
         if (TimeDayOfWeek(li_56) != 0 && TimeDayOfWeek(li_56) != 8 && Highlight_Market_Open && TimeHour(li_56) >= gi_256 && TimeHour(li_56) < gi_260) {
            ObjectSetText("nyl", "NY:", 12, "Arial Bold", labelMktOpenColor);
            ObjectSetText("nyt", l_text_160, 12, "Arial Bold", clockMktOpenColor);
         } else {
            ObjectSetText("nyl", "NY:", 12, "Arial", labelColor);
            ObjectSetText("nyt", l_text_160, 12, "Arial", clockColor);
         }
      }
      if (ShowLondon) {
         if (TimeDayOfWeek(li_64) != 0 && TimeDayOfWeek(li_64) != 8 && Highlight_Market_Open && TimeHour(li_64) >= gi_256 && TimeHour(li_64) < gi_260) {
            ObjectSetText("lonl", "London:", 12, "Arial Bold", labelMktOpenColor);
            ObjectSetText("lont", l_text_112, 12, "Arial Bold", clockMktOpenColor);
         } else {
            ObjectSetText("lonl", "London:", 12, "Arial", labelColor);
            ObjectSetText("lont", l_text_112, 12, "Arial", clockColor);
         }
      }
      if (ShowTokyo) {
         if (TimeDayOfWeek(li_68) != 0 && TimeDayOfWeek(li_68) != 8 && Highlight_Market_Open && TimeHour(li_68) >= gi_256 && TimeHour(li_68) < gi_260) {
            ObjectSetText("tokl", "Tokyo:", 12, "Arial Bold", labelMktOpenColor);
            ObjectSetText("tokt", l_text_120, 12, "Arial Bold", clockMktOpenColor);
         } else {
            ObjectSetText("tokl", "Tokyo:", 12, "Arial", labelColor);
            ObjectSetText("tokt", l_text_120, 12, "Arial", clockColor);
         }
      }
      if (ShowSydney) {
         if (TimeDayOfWeek(li_60) != 0 && TimeDayOfWeek(li_60) != 8 && Highlight_Market_Open && TimeHour(li_60) >= gi_264 && TimeHour(li_60) < gi_268) {
            ObjectSetText("sydl", "Sydney:", 12, "Arial Bold", labelMktOpenColor);
            ObjectSetText("sydt", l_text_96, 12, "Arial Bold", clockMktOpenColor);
         } else {
            ObjectSetText("sydl", "Sydney:", 12, "Arial", labelColor);
            ObjectSetText("sydt", l_text_96, 12, "Arial", clockColor);
         }
      }
      if (ShowAuckland) {
         if (TimeDayOfWeek(li_72) != 0 && TimeDayOfWeek(li_72) != 8 && Highlight_Market_Open && TimeHour(li_72) >= gi_256 && TimeHour(li_72) < gi_260) {
            ObjectSetText("auckl", "Auckland:", 10, "Arial", labelMktOpenColor);
            ObjectSetText("auckt", l_text_128, 10, "Arial", clockMktOpenColor);
         } else {
            ObjectSetText("auckl", "Auckland:", 8, "Arial", labelColor);
            ObjectSetText("auckt", l_text_128, 8, "Arial", clockColor);
         }
      }
      if (ShowMoscow) {
         if (TimeDayOfWeek(li_76) != 0 && TimeDayOfWeek(li_76) != 8 && Highlight_Market_Open && TimeHour(li_76) >= gi_256 && TimeHour(li_76) < gi_260) {
            ObjectSetText("mosl", "Moscow:", 12, "Arial Bold", labelMktOpenColor);
            ObjectSetText("most", l_text_136, 12, "Arial Bold", clockMktOpenColor);
         } else {
            ObjectSetText("mosl", "Moscow:", 12, "Arial", labelColor);
            ObjectSetText("most", l_text_136, 12, "Arial", clockColor);
         }
      }
      if (ShowBerlin) {
         if (TimeDayOfWeek(li_80) != 0 && TimeDayOfWeek(li_80) != 8 && Highlight_Market_Open && TimeHour(li_80) >= gi_256 && TimeHour(li_80) < gi_260) {
            ObjectSetText("berl", "Berlin:", 12, "Arial Bold", labelMktOpenColor);
            ObjectSetText("bert", l_text_144, 12, "Arial Bold", clockMktOpenColor);
         } else {
            ObjectSetText("berl", "Berlin:", 12, "Arial", labelColor);
            ObjectSetText("bert", l_text_144, 12, "Arial", clockColor);
         }
      }
      if (ShowSeattle) {
         if (TimeDayOfWeek(li_84) != 0 && TimeDayOfWeek(li_84) != 6 && Highlight_Market_Open && TimeHour(li_84) >= gi_256 && TimeHour(li_84) < gi_260) {
            ObjectSetText("seal", "Seattle:", 10, "Arial", labelMktOpenColor);
            ObjectSetText("seat", l_text_152, 10, "Arial", clockMktOpenColor);
         } else {
            ObjectSetText("seal", "Seattle:", 8, "Arial", labelColor);
            ObjectSetText("seat", l_text_152, 8, "Arial", clockColor);
         }
      }
      ObjectSetText("brol", "Broker:", 8, "Arial", labelColor);
      ObjectSetText("brot", l_text_168, 8, "Arial", clockColor);
      if (Period() <= PERIOD_D1) {
         ObjectSetText("barl", "Bar Left:", 8, "Arial", labelColor);
         ObjectSetText("bart", StringConcatenate("[ ", l_time2str_180, " ]"), 8, "Arial", clockColor);
      }
   }
   return (0);
}

string TimeToString(int ai_0) {
   string ls_ret_4;
   int l_hour_12 = TimeHour(ai_0);
   if (!Display_Times_With_AMPM) {
      if (Display_Time_With_Seconds) ls_ret_4 = TimeToStr(ai_0, TIME_MINUTES|TIME_SECONDS);
      else ls_ret_4 = TimeToStr(ai_0, TIME_MINUTES);
   } else {
      if (Display_Time_With_Seconds) {
         if (l_hour_12 > 12 || l_hour_12 == 0) ls_ret_4 = TimeToStr(ai_0 - 43200, TIME_MINUTES|TIME_SECONDS);
         else ls_ret_4 = TimeToStr(ai_0, TIME_MINUTES|TIME_SECONDS);
         if (l_hour_12 >= 12) ls_ret_4 = StringConcatenate(ls_ret_4, " PM");
         else ls_ret_4 = StringConcatenate(ls_ret_4, " AM");
      } else {
         if (l_hour_12 > 12 || l_hour_12 == 0) ls_ret_4 = TimeToStr(ai_0 - 43200, TIME_MINUTES);
         else ls_ret_4 = TimeToStr(ai_0, TIME_MINUTES);
         if (l_hour_12 >= 12) ls_ret_4 = StringConcatenate(ls_ret_4, " PM");
         else ls_ret_4 = StringConcatenate(ls_ret_4, " AM");
      }
   }
   return (ls_ret_4);
}

int ObjectMakeLabel(string a_name_0, int a_x_8, int a_y_12) {
   ObjectCreate(a_name_0, OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSet(a_name_0, OBJPROP_CORNER, labelCorner);
   ObjectSet(a_name_0, OBJPROP_XDISTANCE, a_x_8-15);
   ObjectSet(a_name_0, OBJPROP_YDISTANCE, a_y_12);
   ObjectSet(a_name_0, OBJPROP_BACK, TRUE);
   return (0);
}

string FormatDateTime(int ai_0, int ai_4, int ai_8, int ai_12, int ai_16, int ai_20) {
   string ls_24 = ai_4 + 100;
   ls_24 = StringSubstr(ls_24, 1);
   string ls_32 = ai_8 + 100;
   ls_32 = StringSubstr(ls_32, 1);
   string ls_40 = ai_12 + 100;
   ls_40 = StringSubstr(ls_40, 1);
   string ls_48 = ai_16 + 100;
   ls_48 = StringSubstr(ls_48, 1);
   string ls_56 = ai_20 + 100;
   ls_56 = StringSubstr(ls_56, 1);
   return (StringConcatenate(ai_0, ".", ls_24, ".", ls_32, " ", ls_40, ":", ls_48, ":", ls_56));
}

int TimeArrayToTime(int aia_0[4]) {
   int l_str2time_44;
   int li_4 = aia_0[0] & 65535;
   int li_8 = aia_0[0] >> 16;
   int li_16 = aia_0[1] >> 16;
   int li_20 = aia_0[2] & 65535;
   int li_24 = aia_0[2] >> 16;
   int li_28 = aia_0[3] & 65535;
   int li_32 = aia_0[3] >> 16;
   string ls_36 = FormatDateTime(li_4, li_8, li_16, li_20, li_24, li_28);
   l_str2time_44 = StrToTime(ls_36);
   return (l_str2time_44);
}

void GetAllTimeZoneInfo(int aia_0[43], int &aia_4[43], int &aia_8[43], int &aia_12[43], int &aia_16[43], int &aia_20[43], int &aia_24[43], int &aia_28[43], int &aia_32[43]) {
   int li_36 = GetTimeZoneInformation(aia_0);
   aia_4[0] = 300;
   aia_4[17] = 720896;
   aia_4[18] = 65536;
   aia_4[19] = 2;
   aia_4[20] = 0;
   aia_4[21] = 0;
   aia_4[38] = 196608;
   aia_4[39] = 131072;
   aia_4[40] = 2;
   aia_4[41] = 0;
   aia_4[42] = -60;
   aia_8[0] = 0;
   aia_8[17] = 655360;
   aia_8[18] = 327680;
   aia_8[19] = 2;
   aia_8[20] = 0;
   aia_8[21] = 0;
   aia_8[38] = 196608;
   aia_8[39] = 327680;
   aia_8[40] = 1;
   aia_8[41] = 0;
   aia_8[42] = -60;
   aia_12[0] = -540;
   aia_12[17] = 0;
   aia_12[18] = 0;
   aia_12[19] = 0;
   aia_12[20] = 0;
   aia_12[21] = 0;
   aia_12[38] = 0;
   aia_12[39] = 0;
   aia_12[40] = 0;
   aia_12[41] = 0;
   aia_12[42] = 0;
   aia_16[0] = -600;
   aia_16[17] = 262144;
   aia_16[18] = 65536;
   aia_16[19] = 3;
   aia_16[20] = 0;
   aia_16[21] = 0;
   aia_16[38] = 655360;
   aia_16[39] = 65536;
   aia_16[40] = 2;
   aia_16[41] = 0;
   aia_16[42] = -60;
   aia_20[0] = -720;
   aia_20[17] = 262144;
   aia_20[18] = 65536;
   aia_20[19] = 3;
   aia_20[20] = 0;
   aia_20[21] = 0;
   aia_20[38] = 589824;
   aia_20[39] = 327680;
   aia_20[40] = 2;
   aia_20[41] = 0;
   aia_20[42] = -60;
   ArrayCopy(aia_24, aia_8);
   aia_24[0] = -180;
   ArrayCopy(aia_28, aia_8);
   aia_28[0] = -60;
   ArrayCopy(aia_32, aia_4);
   aia_32[0] = 480;
}

void writeLocalTZInfoToFile(string a_name_0, bool ai_8) {
   int lia_12[4];
   int lia_16[43];
   int lia_20[43];
   int li_24 = GetTimeZoneInformation(lia_20);
   if (ObjectFind("timezone") < 0) {
      Alert(WindowExpertName(), ": Open your Terminal window. Go to Experts tab for timezone update instructions!");
      Print(WindowExpertName(), ": If the market zone ST/DST changeover dates change, or to ADD a new market zone, do these steps!");
      Print("... First check for any program updates at: http://forexfactory.com/showthread.php?t=109305");
      Print("... If no update, you can start editing the version you already have.");
      Print("... First temporarily set your CPU clock to the newyork Eastern US timezone.");
      Print("... Next create a text. Make the name \'timezone\'. Make the description \'newyork\'.");
      Print("... Change chart period JUST ONCE -- the file will be appended each change!");
      Print("... Repeat steps to change CPU clock and text for GMT, Tokyo, Sydney, etc.");
      Print("... Start Excel. Open a blank file. Go to Data => Import External Data => Import Data");
      Print("... Import the file: ", TerminalPath(), "\\experts\\files\\", a_name_0);
      Print("... The file is Tab delimited and should provide simple readable columns of data");
      Print("... In MetaEditor, open: ", WindowExpertName(), ".mq4, search for: newyorkTZInfoArray[17]");
      Print("... Change all array values for all timezones according to your Excel spreadsheet");
      Print("... If you THOUGHT you just wrote data but you see this, you missed a step.");
      Print("... Check your text name/description and try again...");
      Print("... When finished... change CPU clock back to normal. Change the timezone update boolean back to FALSE");
      return;
   }
   string ls_28 = ObjectDescription("timezone");
   int l_file_36 = FileOpen(a_name_0, FILE_READ, "\t");
   if (l_file_36 < 0) {
      l_file_36 = FileOpen(a_name_0, FILE_CSV|FILE_WRITE|FILE_READ, "\t");
      if (l_file_36 < 0) {
         Print(a_name_0, " OPEN Error: ", GetLastError());
         return;
      }
      FileSeek(l_file_36, 0, SEEK_END);
      if (ai_8) FileWrite(l_file_36, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, "tzname");
      else FileWrite(l_file_36, 0, 17, 18, 19, 20, 21, 38, 39, 40, 41, 42, "tzname");
      FileClose(l_file_36);
   }
   l_file_36 = FileOpen(a_name_0, FILE_CSV|FILE_WRITE|FILE_READ, "\t");
   if (l_file_36 < 0) {
      Print(a_name_0, " OPEN Error: ", GetLastError());
      return;
   }
   FileSeek(l_file_36, 0, SEEK_END);
   if (ai_8) FileWrite(l_file_36, lia_20[0], lia_20[1], lia_20[2], lia_20[3], lia_20[4], lia_20[5], lia_20[6], lia_20[7], lia_20[8], lia_20[9], lia_20[10], lia_20[11], lia_20[12], lia_20[13], lia_20[14], lia_20[15], lia_20[16], lia_20[17], lia_20[18], lia_20[19], lia_20[20], lia_20[21], lia_20[22], lia_20[23], lia_20[24], lia_20[25], lia_20[26], lia_20[27], lia_20[28], lia_20[29], lia_20[30], lia_20[31], lia_20[32], lia_20[33], lia_20[34], lia_20[35], lia_20[36], lia_20[37], lia_20[38], lia_20[39], lia_20[40], lia_20[41], lia_20[42], ls_28);
   else FileWrite(l_file_36, lia_20[0], lia_20[17], lia_20[18], lia_20[19], lia_20[20], lia_20[21], lia_20[38], lia_20[39], lia_20[40], lia_20[41], lia_20[42], ls_28);
   FileClose(l_file_36);
   Print(WindowExpertName(), ": ", ls_28, " data written to ", TerminalPath(), "\\experts\\files\\", a_name_0);
}

int deinit() {
   if (ShowLocal) {
      ObjectDelete("locl");
      ObjectDelete("loct");
   }
   if (ShowNewYork) {
      ObjectDelete("nyl");
      ObjectDelete("nyt");
   }
   if (ShowUTC_GMT) {
      ObjectDelete("utcl");
      ObjectDelete("utct");
   }
   if (ShowLondon) {
      ObjectDelete("lonl");
      ObjectDelete("lont");
   }
   if (ShowTokyo) {
      ObjectDelete("tokl");
      ObjectDelete("tokt");
   }
   if (ShowSydney) {
      ObjectDelete("sydl");
      ObjectDelete("sydt");
   }
   ObjectDelete("brol");
   ObjectDelete("brot");
   ObjectDelete("barl");
   ObjectDelete("bart");
   if (Show_DIBS_London) {
      ObjectDelete("dibsl");
      ObjectDelete("dibst");
   }
   if (ShowAuckland) {
      ObjectDelete("auckl");
      ObjectDelete("auckt");
   }
   if (ShowMoscow) {
      ObjectDelete("mosl");
      ObjectDelete("most");
   }
   if (ShowBerlin) {
      ObjectDelete("berl");
      ObjectDelete("bert");
   }
   if (ShowSeattle) {
      ObjectDelete("seal");
      ObjectDelete("seat");
   }
   return (0);
}